
from gurobipy import *

# Create a new model
m = Model("X-Luxury_Cloth")

# Define the decision variables
C = m.addVar(vtype=GRB.CONTINUOUS, name="Coats")
S = m.addVar(vtype=GRB.CONTINUOUS, name="Skirts")

# Define the objective function
m.setObjective(12*C + 16*S, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*C + 3*S <= 45, "Designing_Time")
m.addConstr(2.5*C + 3.5*S <= 70, "Printing_Time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Coats: {C.x}")
    print(f"Skirts: {S.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
