
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    C = model.addVar(name="C", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Number of coats
    S = model.addVar(name="S", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Number of skirts

    # Objective function: Maximize profit
    model.setObjective(12*C + 16*S, sense=gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(1.5*C + 3*S <= 45, name="Designing_Time_Constraint")
    model.addConstr(2.5*C + 3.5*S <= 70, name="Printing_Time_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Coats = {C.varValue}, Skirts = {S.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_optimization_problem()
