
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("cheese_mix")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pizza_mix")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mac_cheese_mix")

# Set objective function
model.setObjective(3*x + 3.25*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(4*x + y >= 30, "mozzarella")
model.addConstr(2*x + 5*y >= 25, "cheddar")
model.addConstr(x + 2*y >= 5, "salt")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal}")
    print(f"Pizza Mix Units: {x.x}")
    print(f"Mac & Cheese Mix Units: {y.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

