
from gurobipy import *

# Create a new model
model = Model("Cheese_Mix")

# Define the decision variables
x = model.addVar(lb=0, name="pizza_mix")
y = model.addVar(lb=0, name="mac_and_cheese_mix")

# Define the objective function
model.setObjective(3*x + 3.25*y, GRB.MINIMIZE)

# Define the constraints
model.addConstr(4*x + y >= 30, "mozzarella_constraint")
model.addConstr(2*x + 5*y >= 25, "cheddar_constraint")
model.addConstr(x + 2*y >= 5, "salt_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of pizza mixes: {x.x}")
    print(f"Number of mac and cheese mixes: {y.x}")
    print(f"Total cost: {model.objVal}")
else:
    print("No optimal solution found")
