
import gurobipy as gp

# Create a new model
m = gp.Model("cheese_mix")

# Define the decision variables
x1 = m.addVar(name="pizza_mix", lb=0)  # Amount of Pizza mix
x2 = m.addVar(name="mac_and_cheese_mix", lb=0)  # Amount of Mac and cheese mix

# Objective function: Minimize the total cost
m.setObjective(3*x1 + 3.25*x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(4*x1 + x2 >= 30, name="mozzarella_req")  # Mozzarella requirement
m.addConstr(2*x1 + 5*x2 >= 25, name="cheddar_req")  # Cheddar requirement
m.addConstr(x1 + 2*x2 >= 5, name="salt_req")  # Salt requirement

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found.")
    print(f"Amount of Pizza mix: {x1.varValue}")
    print(f"Amount of Mac and cheese mix: {x2.varValue}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found.")
