
from gurobipy import Model, GRB

# Create a new model
m = Model("hockey_store")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="hockey_sticks") # Number of hockey sticks
y = m.addVar(vtype=GRB.INTEGER, name="pucks") # Number of pucks

# Set objective function
m.setObjective(50*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(75*x + 2*y <= 20000, "budget")
m.addConstr(x >= 50, "min_sticks")
m.addConstr(x <= 110, "max_sticks")
m.addConstr(y <= 3*x, "puck_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: {m.objVal}")
    print(f"Number of Hockey Sticks: {x.x}")
    print(f"Number of Pucks: {y.x}")
else:
    print("Infeasible or unbounded")

