
from gurobipy import *

# Create a new model
m = Model("Hockey_Store_Optimization")

# Define variables
x = m.addVar(lb=50, ub=110, vtype=GRB.INTEGER, name="hockey_sticks")
y = m.addVar(vtype=GRB.INTEGER, name="pucks")

# Set the objective function: Maximize profit
m.setObjective(50*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(75*x + 2*y <= 20000, "budget_constraint")
m.addConstr(y <= 3*x, "puck_sales_limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hockey Sticks to sell: {x.x}")
    print(f"Pucks to sell: {y.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
