
import gurobi

def hockey_store_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=50, ub=110, vtype=gurobi.GRB.INTEGER, name="Hockey_Sticks")
    y = model.addVar(vtype=gurobi.GRB.INTEGER, name="Pucks")

    # Objective function: Maximize profit
    model.setObjective(50 * x + 5 * y, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(75 * x + 2 * y <= 20000, name="Budget_Constraint")

    # Pucks sold constraint
    model.addConstr(y <= 3 * x, name="Pucks_Sold_Constraint")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Hockey Sticks = {x.varValue}, Pucks = {y.varValue}")
        print(f"Max Profit: ${model.objVal}")
    else:
        print("The model is infeasible")

# Run the optimization
hockey_store_optimization()
