
from gurobipy import *

# Create a model
m = Model("Movie_Poster_Optimization")

# Define variables
x_n = m.addVar(vtype=GRB.INTEGER, name="northside_posters")
x_s = m.addVar(vtype=GRB.INTEGER, name="southside_posters")
x_c = m.addVar(vtype=GRB.INTEGER, name="central_posters")

# Objective function: Maximize viewership
m.setObjective(20000*x_n + 50000*x_s + 40000*x_c, GRB.MAXIMIZE)

# Constraints
m.addConstr(500*x_n + 1000*x_s + 800*x_c <= 30000, name="budget_constraint")
m.addConstr(x_s <= 5, name="southside_limit")
m.addConstr(2*x_c <= x_n + x_s, name="central_proportion")
m.addConstr(4*x_n >= x_s + x_c, name="northside_proportion")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Northside posters: {x_n.x}")
    print(f"Southside posters: {x_s.x}")
    print(f"Central posters: {x_c.x}")
else:
    print("No optimal solution found")
