
import gurobi

def solve_poster_placement():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_N = model.addVar(name="Northside", vtype=gurobi.GRB.INTEGER, lb=0)
    x_S = model.addVar(name="Southside", vtype=gurobi.GRB.INTEGER, lb=0)
    x_C = model.addVar(name="Central", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function: Maximize viewership
    model.setObjective(20000*x_N + 50000*x_S + 40000*x_C, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(500*x_N + 1000*x_S + 800*x_C <= 30000, name="Budget")

    # Southside limitation
    model.addConstr(x_S <= 5, name="Southside_Limit")

    # Central mall limitation
    model.addConstr(2*x_C <= x_N + x_S, name="Central_Limit")

    # Northside requirement
    model.addConstr(4*x_N >= x_S + x_C, name="Northside_Requirement")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Northside: {x_N.varValue}")
        print(f"Southside: {x_S.varValue}")
        print(f"Central: {x_C.varValue}")
        print(f"Max Viewership: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_poster_placement()
