
from gurobipy import Model, GRB

# Create a new model
m = Model("winter_sports")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="skis")
y = m.addVar(vtype=GRB.INTEGER, name="snowboards")

# Set objective
m.setObjective(200*x + 175*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(500*x + 400*y <= 20000, "budget")
m.addConstr(x >= 10, "min_skis")
m.addConstr(x <= 30, "max_skis")
m.addConstr(y <= 0.5*x, "snowboard_limit")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Skis:', x.x)
    print('Snowboards:', y.x)
else:
    print("Infeasible or unbounded")

