
from gurobipy import *

# Create a new model
m = Model("Winter_Sports_Store")

# Define variables
x = m.addVar(lb=10, ub=30, vtype=GRB.INTEGER, name="skis")
y = m.addVar(vtype=GRB.INTEGER, name="snowboards")

# Set objective function
m.setObjective(200*x + 175*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(500*x + 400*y <= 20000, "budget")
m.addConstr(y <= 0.5*x, "snowboard_limit")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Skis to buy and sell: {x.x}")
    print(f"Snowboards to buy and sell: {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
