
import gurobi

def solve_ski_and_snowboard_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=10, ub=30, vtype=gurobi.GRB.INTEGER, name="Skis")
    y = model.addVar(vtype=gurobi.GRB.INTEGER, name="Snowboards")

    # Objective function: Maximize profit
    model.setObjective(200 * x + 175 * y, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(500 * x + 400 * y <= 20000, name="Budget")

    # Snowboards sales constraint
    model.addConstr(y <= 0.5 * x, name="Snowboards_vs_Skis")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Skis = {x.varValue}, Snowboards = {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_ski_and_snowboard_problem()
