
import gurobipy as gp

# Create a new model
m = gp.Model("woodworking_profit")

# Create variables
x = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="cutting_boards") # Number of cutting boards
y = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chairs") # Number of chairs

# Set objective function
m.setObjective(14*x + 25*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x + 70*y <= 1500, "time_constraint")
m.addConstr(x + y <= 40, "material_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of cutting boards: {x.x}")
    print(f"Number of chairs: {y.x}")
    print(f"Maximum profit: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

