
from gurobipy import *

# Create a model
m = Model("Wood_Artist_Problem")

# Define decision variables
x = m.addVar(name='cutting_boards', vtype=GRB.INTEGER, lb=0)
y = m.addVar(name='chairs', vtype=GRB.INTEGER, lb=0)

# Objective function: Maximize profit
m.setObjective(14*x + 25*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(30*x + 70*y <= 1500, name='time_constraint')
m.addConstr(x + y <= 40, name='material_constraint')

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Make {x.x} cutting boards and {y.x} chairs.")
else:
    print("No optimal solution found.")

