
import gurobi as gp

# Create a new model
model = gp.Model("Woodworking_Problem")

# Define the decision variables
x = model.addVar(lb=0, name="cutting_boards")  # Number of cutting boards
y = model.addVar(lb=0, name="chairs")  # Number of chairs

# Objective function: Maximize profit
model.setObjective(14 * x + 25 * y, gp.GRB.MAXIMIZE)

# Time constraint: 30x + 70y <= 1500
model.addConstr(30 * x + 70 * y <= 1500, name="time_constraint")

# Material constraint: x + y <= 40
model.addConstr(x + y <= 40, name="material_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Profit: ${model.objVal}")
    print(f"Cutting boards to make: {x.varValue}")
    print(f"Chairs to make: {y.varValue}")
else:
    print("No optimal solution found.")
