
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("vitamin_mix")

# Create variables
x = m.addVar(lb=0, name="orange_juice")
y = m.addVar(lb=0, name="apple_juice")

# Set objective function
m.setObjective(3*x + 9*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x + 10*y >= 100, "vitamin_a")
m.addConstr(5*x + 3*y >= 200, "vitamin_d")
m.addConstr(12*x + 15*y <= 150, "vitamin_e")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Orange Juice (cups): {x.x}")
    print(f"Apple Juice (cups): {y.x}")
    print(f"Total Vitamin K: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

