
from gurobipy import *

# Create a new model
m = Model("Vitamin_Mix")

# Define the decision variables
x = m.addVar(name="orange_juice", lb=0)  # Amount of orange juice
y = m.addVar(name="apple_juice", lb=0)   # Amount of apple juice

# Define the objective function: Minimize Vitamin K
m.setObjective(3*x + 9*y, GRB.MINIMIZE)

# Add constraints for Vitamin A, Vitamin D, and Vitamin E
m.addConstr(6*x + 10*y >= 100, name="Vitamin_A")
m.addConstr(5*x + 3*y >= 200, name="Vitamin_D")
m.addConstr(12*x + 15*y <= 150, name="Vitamin_E")

# Optimize the model
m.optimize()

# Print out the results if the model is optimal
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Orange Juice: {x.x}")
    print(f"Apple Juice: {y.x}")
    print(f"Total Vitamin K: {3*x.x + 9*y.x}")
else:
    print("Model is not optimal")
