
import gurobi

def vitamin_mix_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="orange_juice", lb=0)  # cups of orange juice
    y = model.addVar(name="apple_juice", lb=0)  # cups of apple juice

    # Objective: minimize the total amount of Vitamin K
    model.setObjective(3*x + 9*y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6*x + 10*y >= 100, name="vitamin_A")
    model.addConstr(5*x + 3*y >= 200, name="vitamin_D")
    model.addConstr(12*x + 15*y <= 150, name="vitamin_E")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Minimum Vitamin K: {3*x.varValue + 9*y.varValue}")
    else:
        print("No optimal solution found")

# Run the optimization
vitamin_mix_optimization()
