
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tea_production")

# Create decision variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # Oolong tea
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2") # Green tea

# Set objective function
m.setObjective(30*x1 + 20*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 100, "demand_oolong")
m.addConstr(x2 <= 80, "demand_green")
m.addConstr(x1 + x2 <= 150, "supply")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Oolong Tea (x1): {x1.x}")
    print(f"Green Tea (x2): {x2.x}")
    print(f"Optimal Profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {m.status}")

