
from gurobipy import *

# Create a new model
m = Model("Tea_Shop_Optimization")

# Define decision variables
x1 = m.addVar(lb=0, name="Oolong_Tea")
x2 = m.addVar(lb=0, name="Green_Tea")

# Define the objective function
m.setObjective(30*x1 + 20*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 100, "Demand_Oolong")
m.addConstr(x2 <= 80, "Demand_Green")
m.addConstr(x1 + x2 <= 150, "Supply_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oolong Tea: {x1.x} bottles")
    print(f"Green Tea: {x2.x} bottles")
    print(f"Maximum Profit: ${30*x1.x + 20*x2.x}")
else:
    print("No optimal solution found.")
