
import gurobi as gp

# Create a new model
m = gp.Model("Tea_Shop_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="Oolong_Tea")  # Bottles of oolong tea
x2 = m.addVar(lb=0, name="Green_Tea")   # Bottles of green tea

# Objective function: Maximize profit
m.setObjective(30*x1 + 20*x2, gp.GRB.MAXIMIZE)

# Demand constraints
m.addConstr(x1 <= 100, name="Oolong_Demand_Constraint")
m.addConstr(x2 <= 80, name="Green_Demand_Constraint")

# Supply constraint
m.addConstr(x1 + x2 <= 150, name="Supply_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Oolong Tea: {x1.varValue} bottles")
    print(f"Green Tea: {x2.varValue} bottles")
    print(f"Max Profit: ${30*x1.varValue + 20*x2.varValue}")
else:
    print("No optimal solution found.")
