
import gurobipy as gp

# Create a new model
model = gp.Model("Concert Seating")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="first_floor_seats")
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="second_floor_seats")

# Set the objective function
model.setObjective(100*x + 70*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 250, "total_seats")
model.addConstr(x >= 70, "min_first_floor")
model.addConstr(y >= 2*x, "second_floor_preference")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Profit: ${model.objVal}")
    print(f"First-Floor Seats: {x.x}")
    print(f"Second-Floor Seats: {y.x}")
else:
    print("Infeasible solution")

