
from gurobipy import *

# Create a model
m = Model("Concert_Seats")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="first_floor_seats")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="second_floor_seats")

# Objective function: Maximize profit
m.setObjective(100*x1 + 70*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 250, "total_seats")
m.addConstr(x1 >= 70, "min_first_floor")
m.addConstr(x2 >= 2*x1, "second_floor_preference")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"First-floor seats: {x1.x}")
    print(f"Second-floor seats: {x2.x}")
    print(f"Maximum profit: ${100*x1.x + 70*x2.x}")
else:
    print("No optimal solution found")
