
import gurobi

def solve_concert_seating_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="first_floor_seats", lb=0, ub=250, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="second_floor_seats", lb=0, ub=250, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(100 * x1 + 70 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 250, name="total_seats")
    model.addConstr(x1 >= 70, name="min_first_floor_seats")
    model.addConstr(x2 >= 2 * x1, name="second_floor_preference")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal profit: ${model.objVal:.2f}")
        print(f"First-floor seats to sell: {x1.varValue:.0f}")
        print(f"Second-floor seats to sell: {x2.varValue:.0f}")
    else:
        print("The problem is infeasible.")

solve_concert_seating_problem()
