
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Bobs_Flower_Profit")

# Create variables
x = m.addVar(lb=0, name="daisies") # Acres of daisies
y = m.addVar(lb=0, name="peonies") # Acres of peonies

# Set objective function
m.setObjective(55*x + 80*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "land_constraint")
m.addConstr(20*x + 35*y <= 3000, "budget_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x} acres of daisies")
    print(f"Plant {y.x} acres of peonies")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

