
from gurobipy import *

# Create a new model
m = Model("Bob_Planting")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="daisies")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peonies")

# Set the objective function
m.setObjective(55*x + 80*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "land_limit")
m.addConstr(20*x + 35*y <= 3000, "budget_limit")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Plant {x.x} acres of daisies")
    print(f"Plant {y.x} acres of peonies")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")
