
import gurobi as gp

# Create a new model
model = gp.Model("Daisies_and_Peonies")

# Define variables
x = model.addVar(lb=0, name="daisies")  # Acres of daisies
y = model.addVar(lb=0, name="peonies")  # Acres of peonies

# Objective function: Maximize profit
model.setObjective(55*x + 80*y, gp.GRB.MAXIMIZE)

# Land constraint
model.addConstr(x + y <= 100, name="land_constraint")

# Budget constraint
model.addConstr(20*x + 35*y <= 3000, name="budget_constraint")

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of daisies: {x.varValue}")
    print(f"Optimal acres of peonies: {y.varValue}")
    print(f"Maximal profit: ${model.objVal:.2f}")
else:
    print("The problem is infeasible")
