
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("perfume_cologne")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="perfume_bottles") # Integer number of perfume bottles
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="cologne_bottles") # Integer number of cologne bottles


# Set objective function
m.setObjective(50*x + 60*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + 2.5*y <= 700, "time_constraint")
m.addConstr(x >= 60, "min_perfume")
m.addConstr(y >= 40, "min_cologne")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of perfume bottles (x): {x.x}")
    print(f"Number of cologne bottles (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

