
from gurobipy import *

# Create a new model
m = Model("Perfume_Cologne_Problem")

# Define the decision variables
x = m.addVar(vtype=GRB.INTEGER, name="perfume_bottles")
y = m.addVar(vtype=GRB.INTEGER, name="cologne_bottles")

# Set the objective function to maximize profit
m.setObjective(50*x + 60*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + 2.5*y <= 700, "time_constraint")
m.addConstr(x >= 60, "min_perfume")
m.addConstr(y >= 40, "min_cologne")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Maximum Profit: ${50*x.x + 60*y.x}")
else:
    print("No optimal solution found")
