
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("LeatherProduction")

# Create decision variables
w = m.addVar(lb=0, vtype=GRB.INTEGER, name="wallets") # wallets must be integers
p = m.addVar(lb=0, vtype=GRB.INTEGER, name="purses") # purses must be integers


# Set objective function
m.setObjective(40 * w + 85 * p, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * w + 4 * p <= 2000, "leather_constraint")
m.addConstr(p >= 4 * w, "popularity_constraint")
m.addConstr(w >= 10, "min_wallets_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of wallets: {w.x}")
    print(f"Number of purses: {p.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

