
import gurobipy as gp

# Create a new model
m = gp.Model("Leatherworker_Problem")

# Define variables
W = m.addVar(name="Wallets", lb=10, vtype=gp.GRB.INTEGER)  # At least 10 wallets
P = m.addVar(name="Purses", vtype=gp.GRB.INTEGER)  # Non-negative

# Objective function: Maximize profit
m.setObjective(40 * W + 85 * P, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(2 * W + 4 * P <= 2000, name="Leather_Constraint")  # Leather limit
m.addConstr(P >= 4 * W, name="Purse_to_Wallet_Ratio")  # Purse to wallet ratio

# Solve the model
m.solve()

# Output solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Wallets = {W.varValue}, Purses = {P.varValue}")
    print(f"Max Profit: ${40 * W.varValue + 85 * P.varValue}")
else:
    print("No optimal solution found.")
