
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Seafood_Packaging")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fish_packages")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="shrimp_packages")

# Set objective function
model.setObjective(7*x + 3*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x + 1.5*y <= 1200, "weight_check")
model.addConstr(15*x + 7*y <= 1200, "packaging_inspection")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${model.objVal}")
    print(f"Fish Packages: {x.x}")
    print(f"Shrimp Packages: {y.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

