
from gurobipy import *

# Create a model
m = Model("Seafood_Factory")

# Decision variables
x1 = m.addVar(lb=0, name="fish_packages")
x2 = m.addVar(lb=0, name="shrimp_packages")

# Objective function
m.setObjective(7*x1 + 3*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(3*x1 + 1.5*x2 <= 1200, "weight_checking_machine")
m.addConstr(15*x1 + 7*x2 <= 1200, "packaging_inspection_machine")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Fish packages: {x1.x}")
    print(f"Shrimp packages: {x2.x}")
    print(f"Maximum profit: ${7*x1.x + 3*x2.x:.2f}")
else:
    print("No optimal solution found")
