
import gurobi

def solve_seafood_factory_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="fish_meat", lb=0, ub=gurobi.GRB.INFINITY)
    y = model.addVar(name="shrimp_meat", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(7 * x + 3 * y, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(3 * x + 1.5 * y <= 1200, name="weight_checking_machine")
    model.addConstr(15 * x + 7 * y <= 1200, name="packaging_inspection_machine")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Fish meat packages: {x.varValue}")
        print(f"Shrimp meat packages: {y.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_seafood_factory_problem()
