
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("nut_tin_optimization")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="almond_tins")  # Almond tins
y = m.addVar(vtype=GRB.CONTINUOUS, name="cashew_tins")  # Cashew tins

# Set objective function
m.setObjective(10*x + 15*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + 4*y <= 400, "filling_time")
m.addConstr(3*x + 5*y <= 500, "labeling_time")
m.addConstr(x >= 0, "almond_non_neg")
m.addConstr(y >= 0, "cashew_non_neg")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Almond Tins (x): {x.x}")
    print(f"Cashew Tins (y): {y.x}")
    print(f"Maximum Profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

