
from gurobipy import *

# Create a new model
m = Model("Almond_Cashew_Optimization")

# Define decision variables
A = m.addVar(vtype=GRB.INTEGER, name="almond_tins")
C = m.addVar(vtype=GRB.INTEGER, name="cashew_tins")

# Set the objective function to maximize profit
m.setObjective(10*A + 15*C, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*A + 4*C <= 400, name="filling_time_constraint")
m.addConstr(3*A + 5*C <= 500, name="labeling_time_constraint")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {A.varName} = {A.x}, {C.varName} = {C.x}")
    print(f"Maximum profit: ${10*A.x + 15*C.x:.2f}")
else:
    print("No optimal solution found")

