
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    A = model.addVar(lb=0, name="Almond_Tins")  # Number of almond tins
    C = model.addVar(lb=0, name="Cashew_Tins")  # Number of cashew tins

    # Objective function: Maximize profit
    model.setObjective(10*A + 15*C, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*A + 4*C <= 400, name="Filling_Time_Constraint")
    model.addConstr(3*A + 5*C <= 500, name="Labeling_Time_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Almond Tins: {A.varValue}")
        print(f"Cashew Tins: {C.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_optimization_problem()
