
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("JacketProduction")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="flight_jackets")  # Flight jackets
y = m.addVar(vtype=GRB.CONTINUOUS, name="denim_jackets")  # Denim jackets

# Set objective function
m.setObjective(70*x + 100*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x <= 10, "flight_jacket_limit")
m.addConstr(y <= 25, "denim_jacket_limit")
m.addConstr(x + y <= 30, "sewing_machine_capacity")
m.addConstr(x >= 0, "flight_jacket_nonneg")  # Ensure non-negative production
m.addConstr(y >= 0, "denim_jacket_nonneg")  # Ensure non-negative production


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Produce {x.x:.0f} flight jackets")
    print(f"Produce {y.x:.0f} denim jackets")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

