
from gurobipy import *

# Create a model
m = Model("Jacket_Production")

# Define decision variables
F = m.addVar(lb=0, vtype=GRB.INTEGER, name="Flight_Jackets")
D = m.addVar(lb=0, vtype=GRB.INTEGER, name="Denim_Jackets")

# Set the objective function to maximize profit
m.setObjective(70*F + 100*D, GRB.MAXIMIZE)

# Add constraints
m.addConstr(F <= 10, "Flight_Jacket_Production_Rate")
m.addConstr(D <= 25, "Denim_Jacket_Production_Rate")
m.addConstr(F + D <= 30, "Sewing_Machine_Capacity")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Produce {F.x} flight jackets and {D.x} denim jackets to maximize profit.")
else:
    print("No optimal solution found. The problem may be infeasible.")

