
import gurobi

def solve_jacket_production():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    F = model.addVar(lb=0, ub=10, name="Flight_Jackets")
    D = model.addVar(lb=0, ub=25, name="Denim_Jackets")

    # Objective function: Maximize profit
    model.setObjective(70 * F + 100 * D, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(F <= 10, name="Flight_Jacket_Limit")
    model.addConstr(D <= 25, name="Denim_Jacket_Limit")
    model.addConstr(F + D <= 30, name="Sewing_Machine_Limit")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels: Flight Jackets = {F.varValue}, Denim Jackets = {D.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_jacket_production()
