
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment_Problem")

# Create variables
x = m.addVar(lb=0, name="automotive_investment")
y = m.addVar(lb=0, name="textile_investment")

# Set objective function
m.setObjective(0.1 * x + 0.08 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 30000, "total_investment")
m.addConstr(x >= 3 * y, "investment_ratio")
m.addConstr(x <= 24000, "max_automotive_investment")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in automotive: ${x.x}")
    print(f"Optimal investment in textile: ${y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

