
from gurobipy import *

# Create a new model
m = Model("Investment_Problem")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="automotive_investment")
y = m.addVar(vtype=GRB.CONTINUOUS, name="textile_investment")

# Objective function: Maximize profit
m.setObjective(0.10*x + 0.08*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(x + y <= 30000, "total_investment")
m.addConstr(x >= 3*y, "automotive_vs_textile")
m.addConstr(x <= 24000, "max_automotive")
m.addConstr(x >= 0, "non_negative_x")
m.addConstr(y >= 0, "non_negative_y")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Automotive Investment: ${x.x:.2f}")
    print(f"Textile Investment: ${y.x:.2f}")
    print(f"Max Profit: ${m.ObjVal:.2f}")
else:
    print("No optimal solution found")
