
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="automotive_investment", lb=0)
    y = model.addVar(name="textile_investment", lb=0)

    # Objective function: maximize profit
    model.setObjective(0.10 * x + 0.08 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 30000, name="total_investment_constraint")
    model.addConstr(x >= 3 * y, name="automotive_investment_constraint")
    model.addConstr(x <= 24000, name="automotive_upper_bound_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in automotive industry: ${x.varValue:.2f}")
        print(f"Optimal investment in textile industry: ${y.varValue:.2f}")
        print(f"Maximum profit: ${0.10 * x.varValue + 0.08 * y.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
