
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("ToyCommercials")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="cartoon_commercials")
y = m.addVar(vtype=GRB.CONTINUOUS, name="kids_movie_commercials")


# Set objective function
m.setObjective(5000 * x + 12000 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * x + 4 * y >= 30, "boys_constraint")
m.addConstr(x + 6 * y >= 40, "girls_constraint")
m.addConstr(x >= 0, "x_non_negative")  # Explicit non-negativity constraints
m.addConstr(y >= 0, "y_non_negative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of cartoon commercials (x): {x.x}")
    print(f"Number of kids-movie commercials (y): {y.x}")
    print(f"Minimum cost: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

