
from gurobipy import *

# Create a model
m = Model("Toy_Commercials")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="cartoon_commercials", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="kids_movie_commercials", lb=0)

# Set the objective function
m.setObjective(5000*x + 12000*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x + 4*y >= 30, "young_boys")
m.addConstr(x + 6*y >= 40, "young_girls")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of cartoon commercials: {x.x}")
    print(f"Number of kids-movie commercials: {y.x}")
    print(f"Total cost: ${5000*x.x + 12000*y.x:.2f}")
else:
    print("No optimal solution found")

