
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="cartoon_commercials")
y = model.addVar(lb=0, name="kids_movie_commercials")

# Define the objective function
model.setObjective(5000*x + 12000*y, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(2*x + 4*y >= 30, name="young_boys_constraint")
model.addConstr(x + 6*y >= 40, name="young_girls_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of cartoon commercials: {x.varValue}")
    print(f"Number of kids-movie commercials: {y.varValue}")
    print(f"Total cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
