
import gurobipy as gp

# Create a new model
m = gp.Model("Farm Allocation")

# Create variables
x = m.addVar(name="beets") # Acres of beets
y = m.addVar(name="carrots") # Acres of carrots

# Set objective function
m.setObjective(200*x + 340*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.6*x + 0.7*y <= 10, "tractor")
m.addConstr(0.3*x + 0.25*y <= 10, "plow")
m.addConstr(0.2*x + 0.1*y <= 10, "combine")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Revenue: ${m.objVal:.2f}")
    print(f"Acres of Beets: {x.x:.2f}")
    print(f"Acres of Carrots: {y.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

