
from gurobipy import *

# Create a new model
m = Model("FarmerEquipmentAllocation")

# Define the decision variables
x_b = m.addVar(lb=0, name="acres_beets")
x_c = m.addVar(lb=0, name="acres_carrots")

# Define the objective function: Maximize revenue
m.setObjective(200*x_b + 340*x_c, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.6*x_b + 0.7*x_c <= 10, name="tractor_constraint")
m.addConstr(0.3*x_b + 0.25*x_c <= 10, name="plow_constraint")
m.addConstr(0.2*x_b + 0.1*x_c <= 10, name="combine_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acreage of beets: {x_b.x}")
    print(f"Acreage of carrots: {x_c.x}")
    print(f"Maximum revenue: ${200*x_b.x + 340*x_c.x:.2f}")
else:
    print("No optimal solution found")

