
import gurobi

def solve_farming_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x_b = model.addVar(lb=0, name="beet_acres")
    x_c = model.addVar(lb=0, name="carrot_acres")

    # Define the objective function
    model.setObjective(200 * x_b + 340 * x_c, gurobi.GRB.MAXIMIZE)

    # Add the constraints
    model.addConstr(0.6 * x_b + 0.7 * x_c <= 10, name="tractor_constraint")
    model.addConstr(0.3 * x_b + 0.25 * x_c <= 10, name="plow_constraint")
    model.addConstr(0.2 * x_b + 0.1 * x_c <= 10, name="combine_constraint")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Acres of beets: {x_b.x}")
        print(f"Acres of carrots: {x_c.x}")
        print(f"Max revenue: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_farming_problem()
